. lib

rm -rf bad
mkdir bad
cd bad
darcs init

echo foo > bar
darcs add bar
darcs rec -a -m 'foo'

echo hey > foo
darcs add foo
darcs rec -a -m 'more foo'

hashed=false
test -e _darcs/hashed_inventory && hashed=true

# produce a corrupt patch
echo 'rmfile foo' > _darcs/patches/pending
$hashed || echo -n > _darcs/pristine/foo
darcs rec -a -m 'remove foo'

not darcs check # unapplicable patch!

# stash away contents of _darcs
cp -R _darcs/ _backup_darcs

echo here > bar
darcs rec -a -m 'here'

# corrupt pristine content
$hashed && inv=`grep ^pristine _darcs/hashed_inventory`
cp _backup_darcs/patches/* _darcs/patches/
cp _backup_darcs/*inventory* _darcs/
$hashed && {
    cp _darcs/hashed_inventory hashed.tmp
    sed -e "s,^pristine:.*$,$inv," < hashed.tmp > _darcs/hashed_inventory
    rm hashed.tmp
}

not darcs check # just a little paranoia

darcs repair # repair succeeds
darcs check # and the resulting repo is consistent

# *AND* it contains what we expect...
darcs show contents bar > foobar
echo foo > foobar1
diff foobar foobar1

cd ..
rm -rf bad
